/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import snownee.kiwi.util.InventoryUtil;

public final class PlayerUtil {
    private PlayerUtil() {
    }

    public static BlockPos tryPlaceBlock(World world, BlockPos posPlacedOn, EnumFacing sidePlacedOn, @Nullable EntityPlayer player, EnumHand hand, IBlockState state, @Nullable ItemStack stack, boolean skipCollisionCheck) {
        Block block = world.func_180495_p(posPlacedOn).func_177230_c();
        if (block == Blocks.field_150431_aC && block.func_176200_f((IBlockAccess)world, posPlacedOn)) {
            sidePlacedOn = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)world, posPlacedOn)) {
            posPlacedOn = posPlacedOn.func_177972_a(sidePlacedOn);
        }
        if (world.func_190527_a(state.func_177230_c(), posPlacedOn, skipCollisionCheck, sidePlacedOn, (Entity)player)) {
            return PlayerUtil.tryPlaceBlock(world, posPlacedOn, sidePlacedOn, player, hand, state, stack) ? posPlacedOn : null;
        }
        return null;
    }

    public static boolean tryPlaceBlock(World world, BlockPos pos, EnumFacing sidePlacedOn, @Nullable EntityPlayer player, EnumHand hand, IBlockState state, @Nullable ItemStack stack) {
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        if (player != null && stack != null && !player.func_175151_a(pos, sidePlacedOn, stack)) {
            return false;
        }
        BlockSnapshot blocksnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        if (!world.func_175656_a(pos, state)) {
            return false;
        }
        if (player != null && ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blocksnapshot, (EnumFacing)sidePlacedOn, (EnumHand)hand).isCanceled()) {
            blocksnapshot.restore(true, false);
            return false;
        }
        world.func_180501_a(pos, state, 11);
        IBlockState actualState = world.func_180495_p(pos);
        if (stack != null) {
            ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            if (player != null) {
                player.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
                }
                actualState.func_177230_c().func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            }
            if (player == null || !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        SoundType soundtype = actualState.func_177230_c().getSoundType(actualState, world, pos, (Entity)player);
        world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        return true;
    }

    public static ActionResult<ItemStack> mergeItemStack(ItemStack stack, EntityPlayer player, EnumHand hand) {
        int i;
        Iterator iterator;
        int i2;
        InventoryPlayer inventory = player.field_71071_by;
        ArrayList<Integer> slots = new ArrayList<Integer>(inventory.field_70462_a.size() + inventory.field_184439_c.size());
        int preferred = hand == EnumHand.MAIN_HAND ? inventory.field_70461_c : inventory.field_70462_a.size() + inventory.field_70460_b.size();
        slots.add(preferred);
        for (i2 = 0; i2 < inventory.field_70462_a.size(); ++i2) {
            if (i2 == preferred) continue;
            slots.add(i2);
        }
        for (i2 = inventory.field_70462_a.size() + inventory.field_70460_b.size(); i2 < inventory.field_70462_a.size() + inventory.field_70460_b.size() + inventory.field_184439_c.size(); ++i2) {
            if (i2 == preferred) continue;
            slots.add(i2);
        }
        boolean result = false;
        if (stack.func_77985_e()) {
            iterator = slots.iterator();
            while (iterator.hasNext()) {
                int maxSize;
                i = (Integer)iterator.next();
                if (stack.func_190926_b()) break;
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack.func_190926_b() || !InventoryUtil.stackEqualExact(stack, itemstack)) continue;
                int j = itemstack.func_190916_E() + stack.func_190916_E();
                if (j <= (maxSize = Math.min(inventory.func_70297_j_(), stack.func_77976_d()))) {
                    stack.func_190920_e(0);
                    itemstack.func_190920_e(j);
                    result = true;
                    continue;
                }
                if (itemstack.func_190916_E() >= maxSize) continue;
                stack.func_190918_g(maxSize - itemstack.func_190916_E());
                itemstack.func_190920_e(maxSize);
                result = true;
            }
        }
        if (!stack.func_190926_b()) {
            iterator = slots.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                ItemStack itemstack1 = inventory.func_70301_a(i);
                if (!itemstack1.func_190926_b() || !inventory.func_94041_b(i, stack)) continue;
                if (stack.func_190916_E() > inventory.func_70297_j_()) {
                    inventory.func_70299_a(i, stack.func_77979_a(inventory.func_70297_j_()));
                } else {
                    inventory.func_70299_a(i, stack.func_77979_a(stack.func_190916_E()));
                }
                result = true;
                break;
            }
        }
        if (!stack.func_190926_b()) {
            player.func_71019_a(stack, false);
        } else {
            player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
        }
        return new ActionResult(result ? EnumActionResult.SUCCESS : EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public static boolean canTouch(EntityPlayer player, BlockPos pos) {
        double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        return player.func_174831_c(pos) <= reach * reach;
    }
}

